#ifndef SCHEDULED_SHUTDOWN_H
#define SCHEDULED_SHUTDOWN_H

#include <QWidget>
#include <QSpinBox>
#include <QLabel>
#include <QTimer>

class ScheduledShutdownWidget : public QWidget
{
    Q_OBJECT

public:
    explicit ScheduledShutdownWidget(QWidget *parent = nullptr);

private slots:
    void updateTimeInfo();
    void onScheduleClicked();
    void onCancelClicked();

private:
    QSpinBox *hourSpinBox;
    QSpinBox *minuteSpinBox;
    QLabel *lblCurrentTimeValue;
    QLabel *lblEstTimeValue;
    QTimer *timer;

    void setupUI();
};

#endif // SCHEDULED_SHUTDOWN_H
